clear
close all
% LTS data
LTS = readtable('../Data/LTS/LTS.csv');
startDate = datenum('01-01-1959');
endDate = datenum('12-01-1981');
tGrid = linspace(startDate,endDate,276);
LTS.date = tGrid';

% NBER data
NBER_JOB = readtable('../Data/NBER/JobOpenings.txt');
NBER_JOB.Var4 = [];
NBER_JOB.Properties.VariableNames = {'Year' 'Month' 'JOL'};
NBER_JOB.JOL = str2double(NBER_JOB.JOL);

NBER_EMP = readtable('../Data/NBER/Employment.txt');
NBER_EMP.Var4 = [];
NBER_EMP.Properties.VariableNames = {'Year' 'Month' 'EMP'};
NBER_EMP.EMP = str2double(NBER_EMP.EMP);
NBER = join(NBER_JOB,NBER_EMP,'Keys',{'Year' 'Month'});
NBER.JOR = 100*NBER.JOL./NBER.EMP;

startDateNBER = datenum('01-01-1946');
endDateNBER = datenum('12-01-1969');
tGridNBER = linspace(startDateNBER,endDateNBER,288);
NBER.date = tGridNBER';

NBER = rmmissing(NBER);


lineSpec1 = {'lineWidth', 1, 'lineStyle', '-' , 'Color', rgb('DarkGreen')};
lineSpec2 = {'lineWidth', 1, 'lineStyle', '--', 'Color', rgb('Navy')};
lineSpec3 = {'lineWidth', 1, 'lineStyle', '-.', 'Color', rgb('Maroon')};
lineSpec4 = {'lineWidth', 1, 'lineStyle', ':' , 'Color', rgb('Black')};
gridLineSpec = {'gridlinestyle','--'};

latex={'Interpreter','Latex'};


fontSize = 15;

graphPath = '~/Dropbox/Research/Replacement Hiring/Output/';

hpParam = 129600;

[~,LTS.QUR_cyc] = hpfilter(LTS.QUR,hpParam);
[~,LTS.HIR_cyc] = hpfilter(LTS.HIR,hpParam);
[~,LTS.JOR_cyc((124:180))] = hpfilter(LTS.JOR(124:180),hpParam);
LTS.JOR_cyc(LTS.JOR_cyc==0) = nan;
[~,NBER.JOR_cyc] = hpfilter(NBER.JOR,hpParam);


xLabel = 'Year';
yLabel = 'Rate (\%)';
%% *** Hiring, Quit, Job Opening Rates***
figNum = 1;

figure(figNum)
plot(LTS.date,LTS.HIR,lineSpec1{:})
hold on
plot(NBER.date,NBER.JOR,lineSpec2{:})
plot(LTS.date,LTS.QUR,lineSpec3{:})
plot(LTS.date,LTS.JOR,lineSpec4{:})
hold off
datetick('x','yy')
legend('Hires (LTS)','Job Openings (NBER)','Quits (LTS)','Job Openings (LTS)',latex{:})
grid on
set(gca,gridLineSpec{:})
%set(gca,'FontSize',fontSize)
xlabel(xLabel,latex{:});
ylabel(yLabel,latex{:});


export_fig(figure(figNum),[graphPath 'LTS_HIR_JOR_QUR'],'-pdf','-transparent');

figNum = figNum + 1;

%% *** Cyclicality of Quits and Hires ***
figure(figNum)
plot(LTS.date,LTS.HIR_cyc,lineSpec1{:})
hold on
plot(LTS.date,LTS.QUR_cyc,lineSpec2{:})
hold off
datetick('x','yy')
legend('Hires (LTS)','Quits (LTS)',latex{:})
grid on
set(gca,gridLineSpec{:})
%set(gca,'FontSize',fontSize)
xlabel(xLabel,latex{:});
ylabel(yLabel,latex{:});


export_fig(figure(figNum),[graphPath 'LTS_HIR_QUR_cyc'],'-pdf','-transparent');

figNum = figNum + 1;

%% *** Cyclicality of Quits and Jop Openings ***
figure(figNum)
plot(LTS.date,LTS.JOR_cyc,lineSpec1{:})
hold on
plot(LTS.date,LTS.QUR_cyc,lineSpec2{:})
plot(NBER.date,NBER.JOR_cyc,lineSpec3{:})
hold off
datetick('x','yy')
legend('Jop Openings (LTS)','Quits (LTS)','Job Openings (NBER)',latex{:})
grid on
set(gca,gridLineSpec{:})
%set(gca,'FontSize',fontSize)
xlabel(xLabel,latex{:});
ylabel(yLabel,latex{:});


export_fig(figure(figNum),[graphPath 'LTS_JOR_QUR_cyc'],'-pdf','-transparent');

figNum = figNum + 1;

